********************************************************************************
******************* Extracting OPCS code lists from HES APC ********************
****************************** Chapter 4.2  ************************************

*     Note: This uses the hes_procedures_epi.txt file from hesapc.




*     Setting globals

global codes "My file path:\...\codes\Codelists\data\"
global hesapc "My file path:...\CPRD data _risks\HES APC\Type2_delivery\Results\Aurum_linked\Final\"
global working "My file path:\...\Stata files\Working\"




**/////////////////////// HES Procedures episode /////////////////////////////**
*     Using opcs codes are slightly different to using icd-10 codes.
{
***************** Step 1: Import and save procedures_epi.txt *******************
import delimited "$hesapc\hes_procedures_epi_22_002482.txt", bindquote(nobind) stripquote(no) stringcols(_all)

*     Save
save "$working\HES_procepi.dta"




*     Clear for next step
clear




***************** Step 2: Run icd10 nodots on opcs and tidy ********************
*     Import fracture opcs codes
use "$codes\fracture_opcs.dta"

*     Replace codes with codes without dots
icd10 clean v1, gen(opcs) nodots

*     Rename 
rename v2 description


*     Save 
save "$codes\fracture_opcs_cleaned.dta"




clear




***************** Step 3: Merge codes with Procedures data *********************
use "$working\HES_procepi.dta"


*     Merge with cleaned fracture opcs codelist (clean as in there are no dots in the codes)
merge m:1 opcs using "$codes\fracture_opcs_cleaned.dta"

*     Keep matched
keep if _merge==3

*     Drop uneccesary variables
drop _merge




***************** Step 4: Format dates *****************************************
*     Running the loop below with format all the dates within the Procedures dataset. 
*     Notice there are more dates than in the Diagnoses HES files (Chapter 4.1).

foreach date in admidate epistart epiend discharged evdate {
gen `date'1 = date(`date', "DMY")
format `date'1 %td
drop `date'
rename `date'1 `date'
}


* Checking missing dates
browse if epistart==. | epiend==. | admidate==. | discharged==. | evdate==.




***************** Step 5: Merge with acceptable patients ***********************
merge m:1 patid using "$working\HESlinked_acceptable_patients.dta"

*     Keep those matched
keep if _merge==3

*     Drop uneccesary variables
drop _merge



*     Save file in working file
save "$working\fractures_opcs_procepi.dta"


}

